/*
 *  AIController.h
 *  Pirates2011
 *
 *  Created by Alan Dorin on 10/03/11.
 *  Copyright 2011 __MyCompanyName__. All rights reserved.
 *
 */
#ifndef _AICONT_H_
#define _AICONT_H_

#include "Globals.h"

class Sea;
class Ship;

class AIController
{
	// class Sea needs access to the setShipPtr and setSeaPtr methods
	// but nobody else should have access to these.
	friend class Sea;
			
	private:
		const Ship*	shipPtr;
		const Sea*	seaPtr;
		
		// need to do these from outside via a friend function to protect the ptrs?
		void setShipPtr(const Ship* newShipPtr);
		void setSeaPtr(const Sea* newSeaPtr);
		
	protected:
		// Ship data available to the controller...
		long getShipPositionX(void) const;
		long getShipPositionY(void) const;
		
		Globals::NeighbourDirection getShipAheadDirection(void) const;
		
		long getShipVisionRange(void) const;
		long getShipCannonRange(void) const;
		bool justDamagedShip(void) const;
		long getShipMaxDamage(void) const;
		long getShipDamage(void) const;
		
		bool getShipLastActionSuccess(void) const;
		long getShipRewardStored(void) const;
		
		// Sea data available to the controller...
		bool isGoldMarkerHere(void) const;					// is there a marker for gold here? (gold itself may already have been collected though)
		
		bool isShipAt(long relativeX, long relativeY) const; // relativeX & relativeY must be <= visionRange or false will always be returned
		bool isRockAt(long relativeX, long relativeY) const; // relativeX & relativeY must be <= visionRange or false will always be returned
	
	public:
		AIController(void);
		virtual ~AIController(void);
		
		// this is called by the ship to work out what the controller wants it to do next
		virtual Globals::ShipAction computeNextAction(void) = 0;
};


#endif

